<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class User extends Model 
{

    protected $table = 'users';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('activated', 'activation_code', 'activated_at', 'phone', 'reset_password_code');
    protected $visible = array('activated', 'activation_code', 'activated_at', 'phone', 'reset_password_code', 'timestamps');

    public function socials()
    {
        return $this->hasMany('App\Models\Social', 'id_user');
    }

    public function details()
    {
        return $this->hasOne('App\Models\UserDetail', 'id_user');
    }

    public function throttles()
    {
        return $this->hasOne('App\Models\Throttle', 'id_user');
    }

    public function groups()
    {
        return $this->hasMany('App\Models\UserGroup', 'id_user');
    }

    public function created_groups()
    {
        return $this->hasMany('App\Models\Group', 'id_user');
    }

    public function shops()
    {
        return $this->hasMany('App\Models\Shop', 'id_user');
    }

    public function comments()
    {
        return $this->hasMany('App\Models\Comment', 'id_user');
    }

}